/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.history;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.Diff;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.history.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IWorkbenchPage;

class OpenRevisionAction
extends Action {
    private IWorkbenchPage page;
    private Table table;

    OpenRevisionAction(IWorkbenchPage page, Table table) {
        this.page = page;
        this.table = table;
    }

    public String getText() {
        return Messages.OpenRevisionAction_Text;
    }

    public void run() {
        TableItem[] selected = this.table.getSelection();
        Diff d = (Diff)selected[0].getData();
        GitCommit c = d.commit();
        IFileRevision nextFile = GitPlugin.revisionForCommit((GitCommit)c, (IPath)Path.fromPortableString((String)d.newName()));
        try {
            Utils.openEditor((IWorkbenchPage)this.page, (IFileRevision)nextFile, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
    }
}

